#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Mon May 14 02:33:11 2018

@author: stan
"""
from cpt import CPT
from bayesiannetwork import BayesianNetwork

#defines the conditional probability tables
homicida_t= CPT(
        'homicida',
        [('',0.01)])
sangre_t = CPT(
        'sangre',[('homicida',0.8),('~homicida',0.1)])
cuchillo_t = CPT(
        'cuchillo',[('homicida',0.85),('~homicida',0.25)])

#creates the Bayesian network
bn = BayesianNetwork({
        'homicida':homicida_t,
        'cuchillo':cuchillo_t,
        'sangre':sangre_t})

print(bn)

#perform queries
print("P(homicida) = "+str(bn.query("homicida")))
print("P(sangre) = "+str(bn.query("sangre")))
print("P(cuchillo) = "+str(bn.query("cuchillo")))
print("P(~cuchillo) = "+str(bn.query("~cuchillo")))
print("P(~cuchillo|homicida) = "+str(bn.query("~cuchillo|homicida")))
print("P(homicida|cuchillo,sangre) = \
      "+str(bn.query("homicida|cuchillo,sangre")))