#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
 This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  
May 2018 
    
literal.py

A class for representing literals

@author: Stan (stalinmunoz@yahoo.com)
"""
import re
class Literal:
    
    def __init__(self,input=None,variable=None,value=None):
        if input:
            self.parse(input)
        else:
            self.variable = variable
            self.value = value
        
    def parse(self,input):
        c = re.match("([~]?)\s*(\w+)",input)
        if c is None:
            raise Exception("cannot parse a literal from the input: "+ input)
        self.variable = c.group(2)
        self.value = not c.group(1)
    
    def __str__(self):
        return self.variable if self.value else "~"+self.variable
    
    def __repr__(self):
        return self.__str__()
    
    def __hash__(self):
        return hash(self.__str__())
    
    def __eq__(self,l):
        return l.variable == self.variable and l.value == self.value
    
    def __ne__(self,other):
        return not self.__eq__(other)
        
    def __lt__(self,other):
        if self.variable == other.variable:
            return self.value < other.value
        return self.variable < other.variable