import numpy as np
import pandas as pd
import output_convert as oc

def parse_data(n_experiences):
    N_DATA = n_experiences #from 2 to 1001
    #DATA PARSING
    X = []
    input_ = []
    output_ = []
    N0 = 15 #15 or 20

    #table of the name of the bionets
    str_ = ["arabidopsis", "cardiac", "cd4", "mammalian", "metabolic", "anemia", "aurka", "b-cell", "body-drosophila", "bt474", "bt474-ErbB", "cycle-cdk", "fgf-drosophila", "gonadal", "hcc1954", "hcc1954-ErbB", "hh-drosophila", "l-arabinose-operon", "leukemia", "neurotransmitter", "oxidative-stress", "skbr-long", "skbr3-short", "spz-drosophila", "t-lgl-survival", "tol", "toll-drosophila", "trichostrongylus", "vegf-drosophila", "wg-drosophila", "yeast-cycle", "aspergillus-fumigatus", "budding-yeast", "gene-cardiac", "t-cell-differentiation", "lac-operon-bistability", "core-cell-cycle", "cortical"]

    for s in str_:
    	dataXi_original = pd.read_csv("updated_data/"+ s + "/" + s + "_metrics.csv", sep=",", header=0)
    	N = int(dataXi_original.loc[1, 'N'])
    	antifragility_original = list(np.array(dataXi_original.loc[:, 'Antifragility']).astype(float))
    	# 15 or 20 points describing the relationship between the original values of antifragility in the network before perturbations and X/N
    	X_tmp = list(np.arange(1,N+1, 1))
    	X_N = [X_tmp[i]/N for i in range(N)]
    	original_points = [np.interp(i/N0, X_N, antifragility_original) for i in range(1, N0+1)]

    	for i in range(1,N_DATA):
    		#read the data for each experience
    		n = format(i, '09')
    		dataXi_tmp = pd.read_csv("updated_data/"+ s + "/" + s + "_" + n + "_metrics.csv", sep=",", header=0)

    		antifragility_tmp = list(np.array(dataXi_tmp.loc[:, 'Antifragility']).astype(float))

    		input_tmp = original_points + [np.interp(i/N0, X_N, antifragility_tmp) for i in range(1, N0+1)]

    		evolvable_tmp = list(np.array(dataXi_tmp.loc[:, 'Evolvability']).astype(int))
    		robust_tmp = list(np.array(dataXi_tmp.loc[:, 'Robustness']).astype(int))
    		output_tmp = oc.output_convert(N, evolvable_tmp, robust_tmp)

    		input_.append(input_tmp)
    		output_+= output_tmp

    input_ = np.array(input_)
    output_ = np.array(output_)
    return input_, output_
