import cnn
from parser import parse_data
import itertools
from confusion_matrix import plot_confusion_matrix

"""
(c,b,e) will be read from the command line or a script
(c,b,e) corresponds to the combinations of the specific hyperparameters to build the model
c belongs to {0,1,2,3} and represents the layer architecture
b belongs to {0,1} and represents the batch size
e belongs to {0,1} and represents the number of epochs
"""
#reading arguments from command line

#c = int(sys.argv[1])
#b = int(sys.argv[2])
#e = int(sys.argv[3])

c_ = [0,1,2,3]
b_ = [0,1]
e_ = [0,1]
n_experiences = 1001
combinations = itertools.product(c_,b_,e_)


#parse the data
input_, output_ = parse_data(n_experiences)

#run an specific combination
max_params = (0,0,0)
max_avg_auc = 0

for params in combinations:
    avg_acc, avg_auc, X_train_kfold, X_test_kfold, y_train_kfold, y_test_kfold = cnn.run_nn(input_, output_, n_experiences, params)
    if avg_auc > max_avg_auc:
        max_avg_auc = avg_auc
        max_params = params
        X_train_kfold_opt = X_train_kfold
        X_test_kfold_opt = X_test_kfold
        y_train_kfold_opt = y_train_kfold
        y_test_kfold_opt = y_test_kfold

# once we have chosen the optimal parameters we can do the normal kfold

#note: the test data remains unbalanced
acc, auc, cm = cnn.run_kfold(X_train_opt, X_test_kfold_opt, y_train_kfold_opt, y_test_kfold_opt, max_params)

labels = ['~robust&~evolvable', 'evolvable&~robust', 'robust&~evolvable', 'robust&evolvable']
plot_confusion_matrix(cm, labels)

f = open("acc_auc.txt", 'w+')
f.write("Average accuracy: " + str(acc)+"\n")
f.write("Average area under the curve: " + str(auc))
f.close()

## TO DO: code that allows to execute in parallel, make sure it's the same random shuffle ...
