from itertools import product

B = [0,1]
converter = {(e,r):[i] for (e,r),i in zip(product(B,B),range(4))}

def output_convert(e, r):
    """
    Encodes outputs as integers
    
    Parameters
    -----------
    e : 1 evolvable, 0 not evolvable
    r : 1 robust, 0 not robust
    
    Returns 
    -----------
    the encoded output
    output meaning:
    0 : not evolv. and not rob.
    1 : evol. and not rob.
    2 : not evol. and rob.
    3 : evol. and rob.
    """
    return converter[r,e]
