import pandas as pd
from dash import Dash, Input, Output, dcc, html
import plotly.graph_objects as go

data = (
    pd.read_csv("inventario.csv")
)


comidas = [10, 20, 30, 40]
glucometro = [14, 28,  42]
visitas = [1, 2, 3, 4]

external_stylesheets = [
    {
        "href": (
            "https://fonts.googleapis.com/css2?"
            "family=Lato:wght@400;700&display=swap"
        ),
        "rel": "stylesheet",
    },
]
app = Dash(__name__, external_stylesheets=external_stylesheets)
app.title = "Nutridmex. Inventario de datos"

app.layout = html.Div(
    children=[
        html.Div(
            children=[
                html.P(children="🥑", className="header-emoji"),
                html.H1(
                    children="Inventario de datos", className="header-title"
                ),
                html.P(
                    children=(
                        "Recuento de los datos asociados a cada participante "
                    ),
                    className="header-description",
                ),
            ],
            className="header",
        ),
        html.Div(children=[
            html.Div(children=[
                "Min. Comidas",
                dcc.Slider(
                    id="comida-slider",
                    min=1,
                    max=42,
                    value=10,
                #    marks={10:"babjo", 50:"medio", 100:"alto"}
                ),
                "Dias con Glucómetro",
                dcc.Slider(
                    id="glucosa-slider",
                    min=1,
                    max=42,
                    value=7,
                    #marks={10:"low", 50:"medium", 100:"alto"})
                    ),
                "Visitas",
                dcc.Slider(
                    id="visitas-slider",
                    min=1,
                    max=4,
                    value=1,
                    marks={1:"1", 2:"2", 3:"3", 4:"4"}
                    )
            ]
            ),
            dcc.Graph(id="multi-chart")],
                 className="wrapper"),
    ]
)


@app.callback(
    Output("multi-chart", "figure"),    
    Input("comida-slider", "value"),
    Input("glucosa-slider", "value"),
    Input("visitas-slider", "value"),                
)
def update_charts(comidaslider, glucosaslider, visitaslider):
    filtered_data = data.query(
        "Selectedfoods >= @comidaslider"
    )
    total_data = len(data.index)
    comidas_chart_figure = go.Figure(go.Indicator(
        mode = "gauge+number",
        value = filtered_data["medibles"].count(),
        domain = {'x': [0, 1], 'y': [0, 1]},
        title = {'text': "Ptes"},
        gauge = {'axis': {'range': [None, total_data]}, 'shape': 'bullet'}))

    glucosa_data = data.query("Days_glucose >= @glucosaslider")
    glucosa_chart_figure = go.Figure(go.Indicator(
    mode = "gauge+number",
    value = glucosa_data["medibles"].count(),
    domain = {'x': [0, 1], 'y': [0, 1]},
        title = {'text': "Ptes"},
    gauge = {'axis': {'range': [None, total_data]}, 'shape': 'bullet'}))
    
    visitas_data = data.query("Days_glucose >= @visitaslider")
    visitas_chart_figure = go.Figure(go.Indicator(
    mode = "gauge+number",
    value = visitas_data["medibles"].count(),
    domain = {'x': [0, 1], 'y': [0, 1]},
        title = {'text': "Ptes"},
    gauge = {'axis': {'range': [None, total_data]}, 'shape': 'bullet'}))


    multi = go.Figure()


    comidas_data = data.query("Selectedfoods >= @comidaslider")
    multi.add_trace(go.Indicator(
        mode = "number+gauge+delta", value = comidas_data["medibles"].count(),
        delta = {'reference': 200},
        domain = {'x': [0.25, 1], 'y': [0.08, 0.25]},
        title = {'text': "Con comidas"},
        gauge = {
            'shape': "bullet",
            'axis': {'range': [None, total_data]},
            'threshold': {
                'line': {'color': "black", 'width': 2},
                'thickness': 0.75,
                'value': total_data*0.75},
            'steps': [
                {'range': [0, total_data*0.25], 'color': "gray"},
                {'range': [total_data*0.25, total_data*0.75], 'color': "lightgray"}],
            'bar': {'color': "black"}}))

    glucosa_data2 = data.query("Days_glucose >= @glucosaslider") 
    multi.add_trace(go.Indicator(
        mode = "number+gauge+delta", value = glucosa_data2["medibles"].count(),
        delta = {'reference': 200},
        domain = {'x': [0.25, 1], 'y': [0.4, 0.6]},
        title = {'text': "Glucómetro"},
        gauge = {
            'shape': "bullet",
            'axis': {'range': [None, total_data]},
            'threshold': {
                'line': {'color': "black", 'width': 2},
                'thickness': 0.75,
                'value': total_data*0.75},
            'steps': [
                {'range': [0, total_data*0.25], 'color': "gray"},
                {'range': [total_data*0.25, total_data*0.75], 'color': "lightgray"}],
            'bar': {'color': "black"}}))


    visitas_data = data.query("Nvisitas >= @visitaslider") 
    multi.add_trace(go.Indicator(
        mode = "number+gauge+delta", value = visitas_data["medibles"].count(),
        delta = {'reference': 200},
        domain = {'x': [0.25, 1], 'y': [0.75, 0.95]},
        title = {'text': "Visitas"},
        gauge = {
            'shape': "bullet",
            'axis': {'range': [None, total_data]},
            'threshold': {
                'line': {'color': "black", 'width': 2},
                'thickness': 0.75,
                'value': total_data*0.75},
            'steps': [
                {'range': [0, total_data*0.25], 'color': "gray"},
                {'range': [total_data*0.25, total_data*0.75], 'color': "lightgray"}],
            'bar': {'color': "black"}}))
    

    return   multi


if __name__ == "__main__":
    app.run_server(debug=True, port=8051)
