import pandas as pd
from dash import Dash, Input, Output, dcc, html
import plotly.graph_objects as go

data = (
    pd.read_csv("inventario.csv")
)


comidas = [10, 20, 30, 40]
glucometro = [14, 28,  42]
visitas = [1, 2, 3, 4]

external_stylesheets = [
    {
        "href": (
            "https://fonts.googleapis.com/css2?"
            "family=Lato:wght@400;700&display=swap"
        ),
        "rel": "stylesheet",
    },
]
app = Dash(__name__, external_stylesheets=external_stylesheets)
app.title = "Nutridmex. Inventario de datos"

app.layout = html.Div(
    children=[
        html.Div(
            children=[
                html.P(children="🥑", className="header-emoji"),
                html.H1(
                    children="Inventario de datos", className="header-title"
                ),
                html.P(
                    children=(
                        "Recuento de los datos asociados a cada participante "
                    ),
                    className="header-description",
                ),
            ],
            className="header",
        ),
        html.Div(
            children=[
                html.Div(children="Mínimo de comidas", className="menu-title"),
                dcc.Dropdown(
                    id="comidas-filter",
                    options=[
                        {"label": comida, "value": comida}
                        for comida in comidas
                    ],
                    value=10,
                    clearable=False,
                    className="dropdown",
                ),
                dcc.Graph(
                    id="comidas-chart",
                    config={"displayModeBar": False},
                ),
            ],
            className="wrapper"
        ),
        html.Div(
            children=[
                html.Div(children="Dias con glucómetro", className="menu-title"),
                dcc.Dropdown(
                    id="glucosa-filter",
                    options=[
                        {"label": dia, "value": dia}
                        for dia in glucometro
                    ],
                    value=14,
                    clearable=False,
                    className="dropdown",
                ),
                dcc.Graph(
                    id="glucosa-chart",
                    config={"displayModeBar": False},
                ),
            ],
            className="wrapper"
        ),
        html.Div(
            children=[
                html.Div(children="Visitas", className="menu-title"),
                dcc.Dropdown(
                    id="visitas-filter",
                    options=[
                        {"label": visita, "value": visita}
                        for visita in visitas
                    ],
                    value=4,
                    clearable=False,
                    className="dropdown",
                ),
                dcc.Graph(
                    id="visitas-chart",
                    config={"displayModeBar": False},
                ),
            ],
            className="wrapper"
        ),
    ]
)


@app.callback(
    Output("comidas-chart", "figure"),
    Output("glucosa-chart", "figure"),
    Output("visitas-chart", "figure"),        
    Input("comidas-filter", "value"),
    Input("glucosa-filter", "value"),
    Input("visitas-filter", "value"),    
)
def update_charts(ncomidas, glucosa, nvisitas):
    filtered_data = data.query(
        "medibles >= @ncomidas"
    )
    total_data = len(data.index)
    comidas_chart_figure = go.Figure(go.Indicator(
    mode = "gauge+number",
    value = filtered_data["medibles"].count(),
    domain = {'x': [0, 1], 'y': [0, 1]},
        title = {'text': "Ptes"},
    gauge = {'axis': {'range': [None, total_data]}, 'shape': 'bullet'}))

    glucosa_data = data.query("Days_glucose >= @glucosa")
    glucosa_chart_figure = go.Figure(go.Indicator(
    mode = "gauge+number",
    value = glucosa_data["medibles"].count(),
    domain = {'x': [0, 1], 'y': [0, 1]},
        title = {'text': "Ptes"},
    gauge = {'axis': {'range': [None, total_data]}, 'shape': 'bullet'}))
    
    visitas_data = data.query("Days_glucose >= @nvisitas")
    visitas_chart_figure = go.Figure(go.Indicator(
    mode = "gauge+number",
    value = visitas_data["medibles"].count(),
    domain = {'x': [0, 1], 'y': [0, 1]},
        title = {'text': "Ptes"},
    gauge = {'axis': {'range': [None, total_data]}, 'shape': 'bullet'}))
    

    return comidas_chart_figure, glucosa_chart_figure, visitas_chart_figure


if __name__ == "__main__":
    app.run_server(debug=True)
