import pandas as pd
from dash import Dash, Input, Output, dcc, html
import plotly.graph_objects as go
import plotly.express as px

data = (
    pd.read_csv("inventario.csv")
)


Visitas_e = 4
Etapas_e = 3
Comidas_E1_e = 42
Comidas_E2_e = 9
Comidas_E3_e = 9
Comidas_totales_e = Comidas_E1_e + Comidas_E2_e + Comidas_E3_e
Glucometro_e = 42
Total_pacientes = len(data.index)

scat = px.scatter(data, x="Days_glucose", y="Selectedfoods",size="medibles")
external_stylesheets = [
    {
        "href": (
            "https://fonts.googleapis.com/css2?"
            "family=Lato:wght@400;700&display=swap"
        ),
        "rel": "stylesheet",
    },
]
app = Dash(__name__, external_stylesheets=external_stylesheets)
app.title = "Nutridmex. Inventario de datos"

app.layout = html.Div(
    children=[
        html.Div(
            children=[
                html.P(children="🥑", className="header-emoji"),
                html.H1(
                    children="Inventario de datos", className="header-title"
                ),
                html.P(
                    children=(
                        "Recuento de los datos asociados a cada participante "
                    ),
                    className="header-description",
                ),
            ],
            className="header",
        ),
        html.Div(children=[
            html.Div(children=[
                "Min. Comidas",
                dcc.Slider(
                    id="min_comida",
                    min=1,
                    max=Comidas_totales_e,
                    value=Comidas_totales_e,
                #    marks={10:"babjo", 50:"medio", 100:"alto"}
                ),
                "Dias con Glucómetro",
                dcc.Slider(
                    id="min_glucosa",
                    min=1,
                    max=Glucometro_e,
                    value=Glucometro_e,
                    #marks={10:"low", 50:"medium", 100:"alto"})
                    ),
                "Visitas",
                dcc.Slider(
                    id="min_visitas",
                    min=1,
                    max=Visitas_e,
                    value=Visitas_e,
                    marks={1:"1", 2:"2", 3:"3", 4:"4"}
                    )
            ]
            ),
            html.Div(children=[ 
            dcc.Graph(id="multi-chart")],
                     )],style={'display': 'flex', 'flexDirection': 'row'},
                 className="wrapper"),
        html.Div(
            children=[
                html.Div("Aqui van las gráficas de food analisis", className="wrapper"),
                dcc.Graph(
                    figure={
                        "data": [
                            {
                                "y":data["medibles"],
                                "x":data["nutrid"],
                                "type":"bar"
                            },
                        ],


                        "layout": {"title":"Comidas analizables por paciente"}
                    }),
                dcc.Graph(
                    figure=scat),

                ],
            className="wrapper"
            )
    ]
)


@app.callback(
    Output("multi-chart", "figure"),    
    Input("min_comida", "value"),
    Input("min_glucosa", "value"),
    Input("min_visitas", "value"),                
)
def update_charts(min_comida, min_glucosa, min_visitas):
    total_data = len(data.index)

    


    multi = go.Figure()


    comidas_data = data.query("Selectedfoods >= @min_comida")
    multi.add_trace(go.Indicator(
        mode = "number+gauge", value = comidas_data["medibles"].count(),
        domain = {'x': [0.25, 1], 'y': [0.8, 0.95]},
        title = {'text': "Con comidas"},
        gauge = {
            'shape': "bullet",
            'axis': {'range': [None, total_data]},
            'steps': [
                {'range': [0, total_data*0.1], 'color': "red"},
                {'range': [total_data*0.1, total_data*0.75], 'color': "yellow"},
                {'range': [total_data*0.75, total_data], 'color': "green"}],            
            'bar': {'color': "blue"}}))

    glucosa_data = data.query("Days_glucose >= @min_glucosa") 
    multi.add_trace(go.Indicator(
        mode = "number+gauge", value = glucosa_data["medibles"].count(),
        domain = {'x': [0.25, 1], 'y': [0.4, 0.6]},
        title = {'text': "Glucómetro"},
        gauge = {
            'shape': "bullet",
            'axis': {'range': [None, total_data]},
            'steps': [
                {'range': [0, total_data*0.1], 'color': "red"},
                {'range': [total_data*0.1, total_data*0.75], 'color': "yellow"},
                {'range': [total_data*0.75, total_data], 'color': "green"}],                        
            'bar': {'color': "blue"}}))


    visitas_data = data.query("Nvisitas >= @min_visitas") 
    multi.add_trace(go.Indicator(
        mode = "number+gauge", value = visitas_data["medibles"].count(),
        domain = {'x': [0.25, 1], 'y':[0.08, 0.25]},
        title = {'text': "Visitas"},
        gauge = {
            'shape': "bullet",
            'axis': {'range': [None, total_data]},
            'steps': [
                {'range': [0, total_data*0.1], 'color': "red"},
                {'range': [total_data*0.1, total_data*0.75], 'color': "yellow"},
                {'range': [total_data*0.75, total_data], 'color': "green"}],            
            'bar': {'color': "blue"}}))    

    return   multi


if __name__ == "__main__":
    app.run_server(debug=True, port=8051)
