# Import packages
from dash import Dash, html, dcc, callback, Output, Input 
import pandas as pd
import numpy as np
import plotly.express as px
import plotly.graph_objects as go
from nutri_utils import readGlucosa
from nutri_utils import readPacientes
from nutri_utils import readVisitas
from nutri_utils import readFoods, consolidateFoods, aislaFoods


app = Dash(__name__)

patients = pd.DataFrame(readPacientes())

app.layout = [
    html.Div(children='Glucosa de los Pacientes'),
    dcc.Graph(id = 'glucosa-graph'),
    dcc.Slider(min=30, max = 216, step=1, marks={i: str(i) for i in range(30,217,18)}, value = 30, tooltip= {'always_visible': True} , updatemode = 'drag',
               id = 'slider-patient')
]

@callback(
    Output('glucosa-graph', 'figure'),
    Input('slider-patient', 'value'))
def update_graph(selected_pat):
    glucosa = readGlucosa(selected_pat)
    visita = readVisitas(1)
    foods = aislaFoods(consolidateFoods(readFoods(selected_pat)))
    y_interp = np.interp(foods['fecha_hora'], glucosa['date_time'], glucosa['value'])
    fecha_visita1 =  pd.to_datetime(visita.loc[visita['id'] == selected_pat, 'visit_date'].iloc[0])
    filtered_glucosa = glucosa[(glucosa['date_time'] >= fecha_visita1) & (glucosa['date_time'] <= fecha_visita1 + pd.Timedelta(days=15))]
    
    fig = px.line(filtered_glucosa, x='date_time', y='value', labels={'date_time':'Fecha y Hora','value': 'Valor de Glucosa'})
    fig.add_trace(go.Scatter(x=foods['fecha_hora'], y=y_interp, mode='markers', marker=dict(color='red', size=8)))
    fig.update_layout(transition_duration=500)

    return fig

if __name__ == '__main__':
    app.run(debug=True)
