import pandas as pd
import requests 
import scipy.stats as stats
from datetime import date,datetime
import numpy as np
from urllib.parse import urlparse
import urllib.request
import requests
from PIL import Image
from PIL.ExifTags import TAGS
import re

url_api = 'https://nutricion.c3.unam.mx/nd'


def readGlucosa(participante, solo_fecha=None):

    url_glucosa = url_api + "/patients/" + str(participante) + "/glucouse/data" 
    try:
        df=pd.read_json(url_glucosa, orient='records', convert_dates=False)
        if solo_fecha:
            df=df[df['date']==solo_fecha]
    except:
        print("no hay datos de glucosa para ", participante)
        return pd.DataFrame()
    if not df.empty:
        df["date_time"] = df["date"] + "-" + df["time"]
        df["date_time"] = pd.to_datetime(df["date_time"])
        ordered = df.sort_values(by=["date_time"])
        ordered = ordered.reset_index(drop=True)
        return ordered[["date_time", "value"]]
    else:
        return df
    
def readVisitas(visita):

    visita = 1
    url_visitas = url_api + "/visits/" + str(visita) + "/patients-data/"
    datos = requests.get(url_visitas).json()["patient_data"]
    l1 = [ { cf["controlled_food"]: cf["increment_auc"] for cf in tolerance["tolerance_curve_measure"] } for tolerance in datos ] 
    df1 = pd.json_normalize(datos)
    df1.drop("tolerance_curve_measure", inplace=True, axis=1)
    df1.drop('sample.time_sample_was_taken', inplace=True, axis=1)
    df1.rename(columns= lambda x: x.split(".")[1] if "." in x else x, inplace=True)
    return  pd.concat([df1, pd.DataFrame(l1)], axis=1)
