
sparkrspecies
=============

Funciones para la descarga de Modelos desde la API SPECIES

Paquetes necesarios
-------------------

La descarga de los modelos se realiza con el paquete SparkR, por lo que será necesario realizar su instalación. Para ello es necesario realizar la descarga de Spark, que puede realizarce [aquí](https://spark.apache.org/downloads.html)

NOTA: Las funciones fueron desarrolladas y probadas con la versión 2.4.2, por ello es recomendable se trabaje con ella.

-Descomprimir el archivo y moverlo a la ruta que se desee.

-Creamos la variable SPARK\_HOME en el archivo .Reenviron, para abrirlo se utiliza

``` r
        file.edit(file.path("~", ".Renviron"))
```

-En el agregamos la variable

``` r
        SPARK_HOME = <Directorio donde se encuentra la carpeta de SPARK>
```

-Reiniciamos R y verificamos que la direccion en SPARK\_HOME sea la correcta con

``` r
        Sys.getenv("SPARK_HOME")
```

-Añadimos SparkR al libPath y se carga la libreria

``` r
        .libPaths(c(file.path(Sys.getenv("SPARK_HOME"),"R/lib/"),.libPaths()))

        library(SparkR)
```

Estos dos últimos comandos se utilizaran cada que se desee cargar el paquete SparkR, por lo que se puede crear una función personal, por ejemplo:

``` r
        init() <- function()
          {
            .libPaths(c(file.path(Sys.getenv("SPARK_HOME"),"R/lib/"),.libPaths()))

            library(SparkR)
        }
```

Entonces para volver a usar la libreria unicamente se carga

``` r
        init()
```

Uso de las funciones
--------------------

El uso de las funciones depende de la descarga de los nombres de las especies que se encuentran en la base de datos de la API SPECIES, para ello se utiliza la funcion all\_names

``` r
target <- all_names()
```

Con el data frame target que se obtuvo anteriormente usamos la función LR\_sparkR

``` r
model <- LR_sparkR(target[1:2, 1 , drop = FALSE])
```

Se pueden enviar las especies especificas a la LR\_sparkR, siempre y cuando sean del tipo data.frame
