do_fn <- function(name)
{

  clases <- c("Adenophorea", "Amphibia", "Anthozoa", "Arachnida", "Archiacanthocephala", "Ascidiacea",
              "Asteroidea", "Aves", "Bivalvia", "Branchiopoda", "Calcarea", "Cephalopoda", "Cestoda",
              "Chilopoda", "Chondrichthyes", "Chromadorea", "Clitellata", "Collembola", "Crinoidea",
              "Cubozoa", "Demospongiae", "Diplopoda", "Diplura", "Echinoidea", "Eoacanthocephala",
              "Eurotatoria", "Eutardigrada", "Gastropoda", "Gymnolaemata", "Hexactinellida",
              "Holothuroidea", "Hydrozoa", "Incertae sedis", "Insecta", "Leptocardii", "Lingulata",
              "Malacostraca", "Mammalia", "Maxillopoda", "Monogenoidea", "Myxini", "Ophiuroidea",
              "Osteichthyes", "Ostracoda", "Palaeacanthocephala", "Petromyzontida", "Phascolosomatidea",
              "Polychaeta", "Polyplacophora", "Pycnogonida", "Remipedia", "Reptilia", "Rhabditophora",
              "Rhynchonellata", "Sagittoidea", "Scaphopoda", "Scyphozoa", "Secernentea", "Sipunculidea",
              "Tentaculata", "Thaliacea", "Trematoda", "Udeonychophora", "Xiphosura", "Anthocerotopsida",
              "Bryopsida", "Equisetopsida", "Jungermanniopsida", "Marchantiopsida", "Agaricomycetes",
              "Arthoniomycetes", "Atractiellomycetes", "Chytridiomycetes", "Dacrymycetes", "Dothideomycetes",
              "Eurotiomycetes", "Exobasidiomycetes", "Glomeromycetes", "Lecanoromycetes", "Leotiomycetes",
              "Lichinomycetes", "Microbotryomycetes", "Orbiliomycetes", "Pezizomycetes", "Pucciniomycetes",
              "Saccharomycetes", "Sordariomycetes", "Taphrinomycetes", "Tremellomycetes", "Ustilaginomycetes",
              "Zygomycetes", "Actinobacteria", "Alphaproteobacteria", "Bacilli", "Betaproteobacteria","Cyanophyceae",
              "Deltaproteobacteria", "Flavobacteria", "Gammaproteobacteria", "Sphingobacteria", "Bacillariophyceae",
              "Bangiophyceae", "Charophyceae", "Chlorophyceae", "Chrysophyceae", "Compsopogonophyceae", "Conjugatophyceae",
              "Coscinodiscophyceae", "Cryptophyceae", "Dictyochophyceae", "Dinophyceae", "Euglenophyceae", "Florideophyceae",
              "Fragilariophyceae", "Globothalamea", "Granuloreticulosea", "Hypotrichea", "Klebsormidiophyceae", "Myxomycetes",
              "Noctiluciphyceae", "Oligohymenophorea", "Oligotrichea", "Phaeophyceae", "Picophagophyceae", "Polycystina",
              "Prasinophyceae", "Prymnesiophyceae", "Raphidophyceae", "Stylonematophyceae", "Synurophyceae", "Trebouxiophyceae",
              "Ulvophyceae", "Xanthophyceae")


  library(doParallel)

  nc <- parallel::detectCores() -1

  cl <- parallel::makeCluster(nc)

  doParallel::registerDoParallel(cl)

  out <- foreach::foreach(i = iterators::iter(name, by = "row"),.export=c('georel_lst', 'clases'), .packages = c('doParallel', 'iterators', 		'parallel') , .combine = rbind) %do%
  {

    aux_out <- httr::content(
      httr::POST(paste("http://species.conabio.gob.mx/api/niche/especie",
                       "getEntList", sep = "/"),
                 body = list(searchStr = i,
                             nivel = "especievalidabusqueda",
                             source = "1"),
                 encode = "json"))$data

    aux_data <- do.call(rbind.data.frame, aux_out)

    aux_data<- subset(aux_data, especievalidabusqueda == i)

    id_target <- aux_data$spid

    results <- foreach::foreach(j = iterators::iter(clases), .export = c('georel_lst', 'clases', 'i', 'id_target'), .combine = rbind) %dopar%
    {

      tryCatch(output <- georel_lst(target = i, value = j, id = id_target),

               error = function(e)
               {
                 output <<- data.frame(spid = NA, Specie = NA, nij = NA, nj = NA,
                                       ni = NA, n = NA, kingdom = NA, phylum = NA,
                                       class = NA, order = NA, family = NA,
                                       Epsilon = NA, Score = NA, stringsAsFactors = FALSE)
               },

               finally = (output <- data.frame(Target = i, output, stringsAsFactors = FALSE)))


      return(output)

    }

    return(results)

  }

  return(out)

  parallel::stopCluster(cl)

}
